//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Ui 1.0

import wesual.Create.Private 1.0

import wesual.data.Core 1.0

UiCheckerBoard {
    property alias asset             : thumb.asset
    property alias fallbackThumbnail : thumb.fallbackThumbnail
    property alias showTypeIcon      : thumb.showTypeIcon

    implicitWidth  : 120
    implicitHeight : 120

    states : [
        State {
            name : "ready"
            when : thumb.status === AssetThumbnailPrivate.Ready

            PropertyChanges {
                target  : thumb
                opacity : 1
            }
            PropertyChanges {
                target  : background
                opacity : 0
            }
        },
        State {
            name   : "null"
            when   : thumb.status === AssetThumbnailPrivate.Null
            extend : "ready"
        }
    ]

    transitions : Transition {
        NumberAnimation {
            property : "opacity"
        }
    }

    Rectangle {
        id : background

        anchors.fill : thumb
        color        : asset ? (asset.proxyColor || "#DDD") : "#DDD"
        opacity      : 1
    }

    AssetThumbnailPrivate {
        id : thumb

        anchors.fill : parent
        opacity      : 0
    }

    UiBorder {
        id : thumbBorder

        anchors.fill : thumb
        color        : UiColors.getColor(UiColors.Black, .1)
        borderWidth  : 1
        style        : UiBorder.Solid
    }
}
